VERSION 5.00
Object = "{D6CD40C0-A522-11D0-9800-D3C9B35D2C47}#1.0#0"; "spirit.ocx"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmmain 
   Caption         =   " ScanControl"
   ClientHeight    =   4245
   ClientLeft      =   165
   ClientTop       =   855
   ClientWidth     =   3420
   HasDC           =   0   'False
   Icon            =   "frmmain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   283
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   228
   StartUpPosition =   3  'Windows Default
   Begin MSComDlg.CommonDialog dlgsaveimage 
      Left            =   2880
      Top             =   2400
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin MSComDlg.CommonDialog dlgfirmware 
      Left            =   2880
      Top             =   2880
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.PictureBox picimage 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   3375
      Left            =   240
      ScaleHeight     =   225
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   169
      TabIndex        =   1
      TabStop         =   0   'False
      Top             =   240
      Width           =   2535
   End
   Begin SPIRITLib.Spirit PBrickctrl 
      Height          =   615
      Left            =   240
      TabIndex        =   0
      Top             =   1440
      Visible         =   0   'False
      Width           =   855
      _Version        =   65536
      _ExtentX        =   1508
      _ExtentY        =   1085
      _StockProps     =   0
   End
   Begin VB.Menu downloadmenu 
      Caption         =   "&Download"
      Begin VB.Menu firmware 
         Caption         =   "&download firmware..."
         Shortcut        =   ^F
      End
      Begin VB.Menu downloadprogram 
         Caption         =   "&Download program"
         Shortcut        =   ^D
      End
   End
   Begin VB.Menu scanmenu 
      Caption         =   "&Scan"
      Begin VB.Menu settings 
         Caption         =   "&Options..."
         Shortcut        =   ^O
      End
      Begin VB.Menu Scan 
         Caption         =   "&Start scan"
         Shortcut        =   ^S
      End
   End
   Begin VB.Menu imagemenu 
      Caption         =   "&Image"
      Begin VB.Menu saveimage 
         Caption         =   "&Save image as..."
      End
   End
   Begin VB.Menu about 
      Caption         =   "&About"
      Begin VB.Menu spiritocx 
         Caption         =   "&Spirit.ocx..."
      End
      Begin VB.Menu Scancontrol 
         Caption         =   "&ScanControl..."
      End
   End
   Begin VB.Menu exit 
      Caption         =   "&Exit"
   End
End
Attribute VB_Name = "frmmain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Public white As Integer ' Used to hold the white value polled from the settings wizard
Public Black As Integer ' Used to hold the black value polled from the settings wizard
Private Sub updateimage(color As Integer, unit As Integer, x_value As Integer, y_value As Integer) ' updates the image called scan_Click

color = 255 - ((color - white) * unit) ' convert light sensor value to color

If color > 255 Then ' makes sure that light color is not miscalculated as a dark color
        color = 255
End If

If color < 0 Then ' makes sure that a dark color is not miscalculated as a light color
        color = 0
End If
              
picimage.PSet (x_value, y_value), RGB(color, color, color) 'Updates image

picimage.Refresh

End Sub

Private Sub changedirection() 'changes direction of the scan head

If Pbrickctrl.Poll(0, 1) = 1 Then
    Pbrickctrl.SetVar 1, CON, 0 'changes the variable scanner_direction in the RCX
Else
    Pbrickctrl.SetVar 1, CON, 1 'no change
End If

Call GearBacklash 'Compensate for gear backlash
Pbrickctrl.PlaySystemSound 1

End Sub

Public Sub SetupScanner() ' Setup ligh sensor and angel sensors
Pbrickctrl.SelectPrgm SLOT_1
Pbrickctrl.SetVar 7, CON, 0 'changes the variable whichSubToRun in the RCX
Pbrickctrl.StartTask 0
Call WaitForTaskToFinish 'Wait for RCX to finish task
End Sub
Private Sub FeedPaper() ' Feed paper
Pbrickctrl.SelectPrgm SLOT_1
Pbrickctrl.SetVar 7, CON, 1 'changes the variable whichSubToRun in the RCX
Pbrickctrl.StartTask 0
Call WaitForTaskToFinish 'Wait for RCX to finish task
End Sub

Private Sub movescanner() ' Moves scannerhead in either direction
Pbrickctrl.SelectPrgm SLOT_1
Pbrickctrl.SetVar 7, CON, 2 'changes the variable whichSubToRun in the RCX
Pbrickctrl.StartTask 0
Call WaitForTaskToFinish 'Wait for RCX to finish task
End Sub
Private Sub GearBacklash() 'Compensate for gear backlash
Pbrickctrl.SelectPrgm SLOT_1
Pbrickctrl.SetVar 7, CON, 3 'changes the variable whichSubToRun in the RCX
Pbrickctrl.StartTask 0
Call WaitForTaskToFinish 'Wait for RCX to finish task
End Sub
Private Sub WaitForTaskToFinish() ' Makes visual basic wait for RCX to finish a task
On Error GoTo endsub
  Do While Pbrickctrl.Poll(0, 0) = 0 ' Waits for RCX task to change variable task_finished
  Loop
  Pbrickctrl.SetVar 0, CON, 0 'resets the variable task_finished
Exit Sub
endsub: 'makes program continue - error handling will take place in sub Scan_clik

End Sub

Private Sub downloadprogram_Click() 'downloads the scanner program to the rcx -error handling done with Sub PBrickctrl_DownloadDone
    With Pbrickctrl
        
     
        Const task_finished = 0 'Name of Variable 0
        Const scanner_direction = 1 'Name of Variable 1
        
        Const paper_move = 2 'Name of Variable 2
        Const scanner_move = 3 'Name of Variable 3
        Const gear_backlash = 4 'Name of Variable 4
        Const scanner_move_back = 5 'Name of variable 5
        Const gear_backlash_back = 6 'Name of variable 6
        Const whichSubToRun = 7 'Name of varianle 7
           
        .SelectPrgm SLOT_1
        
        .SetVar task_finished, CON, 0
        
    .BeginOfTask MAIN
        .If VAR, whichSubToRun, 2, CON, 0
            .SetSensorType SENSOR_1, ANGLE_TYPE ' sensor 1 is rotation sensor
            .SetSensorType SENSOR_2, LIGHT_TYPE ' sensor 2 is light sensor
            .SetSensorType SENSOR_3, ANGLE_TYPE ' sensor 3 is rotation sensor
            .SetSensorMode SENSOR_1, ANGLE_MODE, 0 'Sets sensor 1 mode
            .SetSensorMode SENSOR_2, RAW_MODE, 0 'Sets sensor 2 mode
            .SetSensorMode SENSOR_3, ANGLE_MODE, 0 'Sets sensor 3 mode
            .SetVar scanner_move, CON, 116 'Rotations made to move scanhead 1mm
            .SetVar scanner_move_back, CON, -116 'Rotations made to move scanhead 1mm in opposite direction
            .SetVar paper_move, CON, 96 'Rotations made to move paper
            .SetVar scanner_direction, CON, 0 ' sets the direction of the scanner
            .SetVar gear_backlash, CON, 265 ' Rotations made to compensate for gear backlash
            .SetVar gear_backlash_back, CON, -265 ' Rotations made to compensate for gear backlash in opposite direction
            .SetVar task_finished, CON, 1 ' Tells visual basic task has finished
        .EndIf
        
        .If VAR, whichSubToRun, 2, CON, 1 'Feeds paper
            .ClearSensorValue SENSOR_1
            .SetFwd MOTOR_B
            .While SENVAL, SENSOR_1, LT, VAR, paper_move
            .On MOTOR_B
            .EndWhile
            .Off MOTOR_B
            .SetVar task_finished, CON, 1 ' Tells visual basic task on RCX has finished
        .EndIf
        
        .If VAR, whichSubToRun, 2, CON, 2 ' Move scannerhead
            .If VAR, scanner_direction, 2, CON, 0
                .ClearSensorValue SENSOR_3
                .SetFwd MOTOR_A
                .While SENVAL, SENSOR_3, LT, VAR, scanner_move
                .On MOTOR_A
                .EndWhile
                .Off MOTOR_A
            .Else
                .ClearSensorValue SENSOR_3
                .SetRwd MOTOR_A
                .While SENVAL, SENSOR_3, GT, VAR, scanner_move_back
                .On MOTOR_A
                .EndWhile
                .Off MOTOR_A
            .EndIf
            
            .SetVar task_finished, CON, 1 ' Tells visual basic task on RCX has finished
        .EndIf
        
        .If VAR, whichSubToRun, 2, CON, 3 ' Move Gear backlash
            .If VAR, scanner_direction, 2, CON, 0
                .ClearSensorValue SENSOR_3
                .SetFwd MOTOR_A
                .While SENVAL, SENSOR_3, LT, VAR, gear_backlash
                .On MOTOR_A
                .EndWhile
                .Off MOTOR_A
            .Else
                .ClearSensorValue SENSOR_3
                .SetRwd MOTOR_A
                .While SENVAL, SENSOR_3, GT, VAR, gear_backlash_back
                .On MOTOR_A
                .EndWhile
                .Off MOTOR_A
            .EndIf
            
            .SetVar task_finished, CON, 1 ' Tells visual basic task has finished
        
        .EndIf
        
        
    .EndOfTask
    End With
settings.Enabled = True 'The user can now select the scan settings
End Sub

Private Sub exit_Click() ' Closes program
Pbrickctrl.CloseComm
End
End Sub

Private Sub firmware_Click() ' Download firmware - error handling done with Sub PBrickctrl_DownloadDone
    Dim firmwareFile As String
    
    dlgfirmware.Filter = "LEGO Firmware (firm0309.lgo)|firm0309.lgo" 'sets filter for dialog dlgfirmware
    dlgfirmware.ShowOpen
    firmwareFile = dlgfirmware.FileName
    frmdownloadstatus.Show ' shows download status screen
    Pbrickctrl.DownloadFirmware firmwareFile ' the download starts
End Sub

Private Sub PBrickctrl_DownloadDone(ByVal ErrorCode As Integer, ByVal DownloadNo As Integer) ' check download
If ErrorCode = 0 Then ' Download is ok
    Pbrickctrl.PlaySystemSound SWEEP_DOWN_SOUND
    frmdownloadstatus.Hide
    MsgBox "Downloaded Successful", vbInformation, "Status"
    Pbrickctrl.UnlockFirmware ("Do you byte, when I knock?")
Else ' Download failed
    frmdownloadstatus.Hide
    MsgBox "Download Failed - please try again", vbCritical, "Status"
End If


End Sub
Private Sub saveimage_Click() ' Saves image
On Error GoTo Errorhandling
dlgsaveimage.Filter = "bitmap (*.bmp)|*.bmp" 'sets filter for dialog dlgsaveimage
dlgsaveimage.ShowSave
SavePicture picimage.Image, dlgsaveimage.FileName 'saves image
Exit Sub
Errorhandling: ' just continue

End Sub

Private Sub scan_Click() 'Scans the image
Dim x_axe As Integer 'x
Dim y_axe As Integer 'y
Dim MyColor As Integer 'color
Dim unit As Integer 'unit holds the value used to convert light sensor readings to color
Dim Paperlenth As Integer 'tells how many times the paper has been loaded
Dim scannermove As Integer 'tells how many times the scanner head has moved
Dim dimention_x As Integer 'holds the x dimentions of the scan
Dim dimention_y As Integer 'holds the y dimentions of the scan

On Error GoTo Errorhandling

dimention_x = picimage.Width ' sets x dimention
dimention_y = picimage.Height 'sets y dimention
unit = 255 / (Black - white) 'Sets unit - used to uddate image

x_axe = dimention_x 'sets the start value for x_axe
y_axe = 0 'sets the start value for y_axe



Paperlenth = 0 'Papper has not been loaded


Do While Paperlenth < dimention_y
   
            scannermove = 0 ' scan head has not moved
            
            Do While scannermove <= dimention_x
                
                MyColor = Pbrickctrl.Poll(SENVAL, SENSOR_2) ' Polls the color to be converted
                Call updateimage(MyColor, unit, x_axe, y_axe) ' updates the image
                x_axe = x_axe - 1
                Call movescanner ' moves scanner
                scannermove = scannermove + 1
                
            Loop
            'scanner head reaches end of image
            
            scannermove = 0 ' scan heas has not moved
            
            Call changedirection ' changes direction
            Paperlenth = Paperlenth + 1
            Call FeedPaper ' feeds paper
            y_axe = y_axe + 1 '
            
            Do While scannermove <= dimention_x
                MyColor = Pbrickctrl.Poll(SENVAL, SENSOR_2) ' Polls the color to be converted
                Call updateimage(MyColor, unit, x_axe, y_axe) ' updates the image
                x_axe = x_axe + 1
                Call movescanner ' moves scanner
                scannermove = scannermove + 1
            Loop
            'scanner head reaches end of image
            
            Call changedirection ' changes direction
            Paperlenth = Paperlenth + 1
            Call FeedPaper 'feeds paper
            y_axe = y_axe + 1

Loop
'Scanning is finished

saveimage.Enabled = True ' Allows user to save image

Exit Sub

Errorhandling:
 If Err.Number = 68 Then
    MsgBox "Connection with RCX Lost", vbCritical, "Connection Lost"
    
 Else
    MsgBox "Unknown Error occured", vbCritical, "Error"
   
 End If
    
End Sub

Private Sub Scancontrol_Click() ' shows about
frmabout.Show
End Sub

Private Sub settings_Click() ' shows scan settings

On Error GoTo Errorhandling
Call SetupScanner 'sets sensors and variables
frmsettings.Show

Exit Sub

Errorhandling:
If Err.Number = 68 Then
    MsgBox "Connection with RCX Lost", vbCritical, "Connection Lost"
    
 Else
    MsgBox "Unknown Error occured", vbCritical, "Error"
   
 End If
 
End Sub
Private Sub Form_Load() ' when form loads
saveimage.Enabled = False 'user unable to saveimage
Scan.Enabled = False 'user unable to scan
settings.Enabled = False 'user unable to set settings
Pbrickctrl.InitComm ' enables communication with RCX
End Sub

Private Sub spiritocx_Click() 'shows spirit.ocx about
Pbrickctrl.AboutBox
End Sub
