#include <msp430x16x.h>
#include "basic_clock_module.h"
#include "uart.h"
#define BUFFER_SIZE 120 //Holds 10 RFID-readings 
char U1_rx_buffer[BUFFER_SIZE]; //UART 1 receive buffer
char  U1_rx_write_idx = 0, U1_rx_read_idx=0, U1_rx_size=0;//UART 1 index' to receive buffer

//Sets up UART 1 to read from RFID-reader
//See RFID datasheet at http://info.hobbyengineering.com/specs/PARALLAX-RFIDReader1.pdf
void init_uart1(){
    unsigned int br; 
    unsigned char br1, br0; 
    br = (unsigned int)(XT2/2400);//Sets the Baud-rate to 2400  
    br0 = (unsigned char)(br & 0x00FF);  
    br1 = (unsigned char)(br >> 8);   
    
    U1CTL &=~BIT0;// Software reset off 
    U1CTL |= BIT4;// 8 bit character length
    
    U1TCTL |= BIT4;// Use SMCLK as clocksignal 
    U1TCTL |= BIT5;// -"-  
   
    U1BR0 = br0;// Baud-rate Low byte
    U1BR1 = br1;// High byte -"- 
    U1MCTL = 0x00; 
     
    ME2 |= BIT4;// UART1 rx enabled 
    
    P3SEL |= BIT7;//Selection of input pin P3.7 as rx (pin 35)
    
    IE2 |= BIT4;// UART1  receive interrupt enable 
    return;
}
//Recieve interrupt for UART 1 stores the incomming byte in rx buffer
#pragma vector = UART1RX_VECTOR
__interrupt void uart1_rx_interrupt(void) {
    if(U1_rx_size<BUFFER_SIZE){
    
        U1_rx_buffer[U1_rx_write_idx] = U1RXBUF;///Save byte from U0RXBUF              
        U1_rx_write_idx++;      
        if(U1_rx_write_idx >= BUFFER_SIZE){
             U1_rx_write_idx=0;
        }  
        U1_rx_size++;
    }
    return;
} 
//Returns the next byte from UART 1 rx-buffer returns -1 if no new bytes in buffer
int uart1_rx(){
    int byte;
    if(U1_rx_size!=0){
        byte = (int) U1_rx_buffer[U1_rx_read_idx];
        U1_rx_read_idx = (U1_rx_read_idx+1)%BUFFER_SIZE;
        U1_rx_size--;
        return byte;
    }
    return -1;
}
