#include <msp430x16x.h>
#include "uart.h"
#include "rfid.h"
#include "tags.h"
char current_state;
char new_tag=0; //Indicates if a new RFID-tag has been read
char rfid_tag_id;


/************State machine data********************/  
#define START_BYTE 0x0A //see http://info.hobbyengineering.com/specs/PARALLAX-RFIDReader1.pdf
#define STOP_BYTE 0x0D//

//states
#define WAIT_START_BYTE 0  
#define RECIEVE_DATA_BYTES 1  
#define WAIT_STOP_BYTE 2
char rfid_data[RFID_LENGTH];//Holds data from UART1 that is curently being processed in the state machine
char state=WAIT_START_BYTE;//Start state in the state machine
int data_bytes_recieved=0;
/***********End af state machine data ****************/

//turns off the RFID-reader
void rfid_off(){
   P3OUT |= BIT6;
   current_state=0;
}

//turns on the RFID-reader
void rfid_on(){
    P3OUT &= ~BIT6;
    current_state=1;
}

void init_rfid(){
   P3DIR |= BIT6;   // P3.6 as output (pin 34)
   rfid_off();
   current_state=0;
}
//returns the state of the RFID-reader 0=off 1=on
char rfid_state(){
    return current_state;
}

//Returns a pointer to the larst RFID-tag read. The tag is 10 bytes long  
char rfid_tag(){
    new_tag=0;
    return rfid_tag_id;
}

//Tells if a new RFID-tag has been read returns 1 or 0
char new_rfid_tag(){
    return new_tag;
}
/********** State machine - see www.norgesgade14.dk/rfid.php for diagram ************* 
updates the rfid-tag buffer - must be call continuuosly otherwise UART might get full 
new bytes from the UART is handled in a state machine. 
In case of a valid RFID-string this string is saved in rfid_data buffer and new_tag is set high*/  

void update_rfid(){
    int byte=uart1_rx();
    if(byte==-1){//No data in UART buffer 
        return;   
    }
    //state machine
    switch(state){
        case WAIT_START_BYTE:
            if(byte==START_BYTE){
                data_bytes_recieved=0;
                state=RECIEVE_DATA_BYTES;
            } 
        break;
       
        case RECIEVE_DATA_BYTES:
            
            if(byte==START_BYTE){
                data_bytes_recieved=0;
                state=RECIEVE_DATA_BYTES;
                
            }
            else if(byte==STOP_BYTE){
                state=WAIT_START_BYTE;
            }
            else{//byte is data byte
              if(data_bytes_recieved < RFID_LENGTH-1){
                 rfid_data[data_bytes_recieved]=byte;
                 data_bytes_recieved++;
                 state=RECIEVE_DATA_BYTES;
              }
              else{
                  rfid_data[data_bytes_recieved]=byte;
                  state=WAIT_STOP_BYTE;               
              }
            }
        break;
        
        case WAIT_STOP_BYTE:
         
            if(byte==START_BYTE){
                data_bytes_recieved=0;
                state=RECIEVE_DATA_BYTES;
                
            }
            else if(byte==STOP_BYTE){//RFID-tag is valid
              rfid_tag_id=get_rfid_id(&rfid_data[0]);
              new_tag=1;
              state=WAIT_START_BYTE;
            }
            else{//byte is data byte
               state=WAIT_START_BYTE;
            }
        break;
    }


}

