#include "rfid.h"
#include "tags.h"
#define NO_TAGS 2 //keeps track of how many tags the file hold be sure to increment if you add a tag 

//////////////////////////////
//Flash store and save not made
///////////////////////////////
struct rfid_data{
    char byte[RFID_LENGTH];
    char id;
    char id_high;
};

struct rfid_tags{
   struct rfid_data tag[NO_TAGS];
   char size;
};

struct rfid_tags rfid_list;

void add_tag(char data[RFID_LENGTH], char id){
  char i=0;
  char index=rfid_list.size;
  while(i<RFID_LENGTH){
      rfid_list.tag[index].byte[i]=data[i];
      i++;
  }
  rfid_list.tag[index].id=id;
  rfid_list.size++;
}


void init_tags(){
   char tag_data[RFID_LENGTH]; 
   char id;
   rfid_list.size=0;
   //Add the RFID_TAGS below orderd by ID -- keep it that way
   
   //ID=1 
   id=1;
   tag_data[0]= 0x30; tag_data[1]=0x46; tag_data[2]=0x30 ; tag_data[3]=0x32 ; tag_data[4]=0x39; 
   tag_data[5]=0x36 ; tag_data[6]=0x41 ; tag_data[7]=0x46 ; tag_data[8]=0x32 ; tag_data[9]=0x44; 
   add_tag(tag_data, id);
   
   //ID=2 
   id=2;
   tag_data[0]= 0x30; tag_data[1]=0x46; tag_data[2]=0x30 ; tag_data[3]=0x32 ; tag_data[4]=0x39; 
   tag_data[5]=0x36 ; tag_data[6]=0x41 ; tag_data[7]=0x46 ; tag_data[8]=0x32 ; tag_data[9]=0x45; 
   add_tag(tag_data, id);
}

//Returns the ID of the RFID tag if the ID is not found 0 is returned 
char get_rfid_id(char *rfid_tag){
   char i;
   char id;
   int k=rfid_list.size-1;
   char match=0;
   while(k>=0 && !match){
       i=0;
       match=1;
       id=rfid_list.tag[k].id;
       while(i<RFID_LENGTH && match){
         if(rfid_list.tag[k].byte[i]!=rfid_tag[i]){
             match=0;
             id=0;
         }
         i++;   
       }
       k--;
   }               
   return id;
}
                       
