#include <msp430x16x.h>
#include "basic_clock_module.h"
#include "i2c.h"
#include "rfid.h"
#define I2C_ADDRESS 0x06
//Valid commands send from NXT
#define RFID_ON              0x01
#define RFID_OFF             0x02
#define GET_STATE            0x03
#define NEW_RFID_TAG         0x04
#define GET_RFID_TAG         0x05
char command;

void init_i2c(){
  
  P3SEL |= 0x0A;//Selection of SCL and SDA (SCL=pin 31 SDA=pin 29 )
  U0CTL |= I2C + SYNC;// I2C mode

  U0CTL &= ~I2CEN;// I2C off in order to write to registers

  I2CTCTL |=  BIT5;// SMCLK as source
  I2CTCTL |=  BIT4;// -"- 
  
  I2COA = I2C_ADDRESS >> 1;//Set address. Right shift is a hack to make it match NXT address
  
  I2CIE = RXRDYIE+TXRDYIE;    //RX TX and start interrupt enable
  U0CTL |= I2CEN;// I2C enable 
           
}

//Common interrupt for i2c 
#pragma vector=USART0TX_VECTOR
__interrupt void I2C_ISR(void)
{
  volatile unsigned int i = 0;  
  switch( I2CIV ){
       case I2CIV_RXRDY: //RX data
         command=I2CDRB;
         //Execute know commands
         if(command==RFID_ON){
                 rfid_on();
          }
          if(command==RFID_OFF){
                rfid_off();
          }
     break;
   
     case I2CIV_TXRDY://Tx interrupt
        //Find know commands and reply
         switch(command){
             case RFID_ON:
                 I2CDRB=rfid_state();
             break;  
       
             case RFID_OFF:
                 I2CDRB=rfid_state();
             break;
       
             case GET_STATE:
                 I2CDRB=rfid_state();
             break;
       
             case NEW_RFID_TAG:
                 I2CDRB = new_rfid_tag();
             break;
       
             case GET_RFID_TAG:
                   I2CDRB = rfid_tag();
             break;
             default: I2CDRB = 0xff;// No knwo command found
             //End of nested switch
             
       }
     break;
 }
        
}





