#ifndef SONAR
#define SONAR
#include <iostream>
#include <string>
#include "serial.hpp"
#include "I2C.hpp"


using namespace std;

//Modes
enum {OFF=0x00, SINGLE_SHOT=0x01, CONTINUOUS_MEASUREMENT=0x02, EVENT_CAPTURE=0x03, REQUEST_WARM_RESET=0x04};

//registers
enum {SONAR_ADDRESS=0x02,INTERVAL=0x40, COMMAND=0x41, RESULT_1=0x42, RESULT_2=0x43, RESULT_3=0x44, RESULT_4=0x45, 
      RESULT_5=0x46, RESULT_6=0x47, RESULT_7=0x48, RESULT_8=0x49, ZERO_VALUE = 0x50, SCALE_FACTOR=0x51, SCALE_DIVISOR=0x52, 
      FACTORY_ZERO_VALUE = 0x11, FACTORY_SCALE_FACTOR=0x12, FACTORY_SCALE_DIVISOR=0x13};

class Sonar{
private:
    I2C sensor;
    int scale_factor;
    float cm;
    float inch;
    float mode;
    
    int write_register(int reg_adr, int value);
    int read_register(int reg_adr);
    
    int sensor_mode(int mode);
    
    int set_scale_factor(int factor);
    int set_scale_divisor(int divisor);
    int set_measurement_interval(int interval);
    int set_zero_value(int value);
    
    int get_measurement_interval();
    int get_command_state();
    int get_scale_factor();
    int get_scale_divisor();
    int get_zero_value();

    int get_factory_zero_value();
    int get_factory_scale_factor();
    int get_factory_scale_divisor();
    
    int off();
    int reset();
    

public:
    Sonar();
    Sonar(int input_port, Serial *cp);
    int inch_mode();
    int cm_mode();
    int set_scale(int factor);
    int setup();
    //needs some work!!
    //int record();
    int distance();
};
#endif
