#include <iostream>
#include "sensor.hpp"
#include <stdio.h>
#include <time.h>
#include <string>
#include <stdlib.h>
using namespace std;

    
    Sensor::Sensor(){
    }
    Sensor::Sensor(int input_port, Serial *cp){
        port=input_port;
        comport=cp;
    }

    int Sensor::type_and_mode(int type, int mode){
         char command[7];
         command[0]=0x05;  //command length
         command[1]=0x00;

         //start of message
         command[2]=0x80;
         command[3]=0x05;

         command[4]=port;
         command[5]=type;//input port
         command[6]=mode;//set mode
         return comport->send(&command[0],7);    
    }
    
    int Sensor::get_sensor_value(){
        char command[5];
        char *answer;
        command[0]=0x03;
        command[1]=0x00;
        
        command[2]=0x00;
        command[3]=0x07;
        command[4]=port;
        comport->send(&command[0],5);    
        answer=comport->receive(18);
        raw=((0xff & answer[10]) | (answer[11] << 8)); 
        adc=((0xff & answer[12]) | (answer[13] << 8)); 
        mode=((0xff & answer[14]) | (answer[15] << 8)); 
        calcu=((0xff & answer[16]) | (answer[17] << 8)); 
        return 1;
    }
    
    int Sensor::reset(){
        char command[5];
        command[0]=0x03;  //command length
        command[1]=0x00;

        //start of message
        command[2]=0x80;
        command[3]=0x08;
        command[4]=port;
        return comport->send(&command[0],5);    
    }
    
    int Sensor::read(){
        get_sensor_value();
        return mode;    
        
    }
    
    int Sensor::read_raw(){
        get_sensor_value();
        return raw;    
        
    }
    
    int Sensor::read_adc(){
        get_sensor_value();
        return raw;    
    }

/*    int Sensor::change_port(int new_port){
        port=new_port;
    }*/
    
    

