#include <iostream>
#include "sound.hpp"
#include <stdio.h>
#include <time.h>
#include <string>
#include <stdlib.h>
using namespace std;

    Sound::Sound(){
                       
    }
    Sound::Sound(Serial *cp){
        comport=cp;               
    }
    int Sound::play_tone(unsigned int freq, unsigned int time){
        char command[8];
        command[0]=0x06;  //command length
        command[1]=0x00;
        command[2]=0x80;
        command[3]=0x03;
        command[4]=freq;
        command[5]=freq >>8;
        command[6]=time;
        command[7]=time >> 8;
        return comport->send(&command[0],8);
    }
    
    int Sound::beep(unsigned int time){
        return play_tone(1000,time);
    }
    
    int Sound::play_file(string file, bool loop){
        char *answer;
        char command[MAX_NR_BYTES];
        int length=file.length();
        int i;
        if(length>19){
            length=19;
        }
        /* output to bluetooth*/
        command[0]=length+4;  //command length
        command[1]=0x00;
        /*start of message*/
        command[2]=0x00;
        command[3]=0x02;
        command[4]=loop;
        for(i=0; i<length ;i++){
             command[i+5]=file[i];
        }
        command[i+5]='\0';
        comport->send(&command[0],length+6);
        answer= comport->receive(5);
        if(answer[4]){
            return -1;              
        }
        else{
            return 1;     
        }    
    }
    int Sound::stop_playback(){
        char command[4];
        command[0]=0x02;  //command length
        command[1]=0x00;
        
        command[2]=0x80;
        command[3]=0x0C;
        return comport->send(&command[0],4);    
    
    }
                
