#ifndef SENSOR
#define SENSOR
#include <iostream>
#include <string>
#include "serial.hpp"

using namespace std;

//sensor types
enum {NO_SENSOR=0x00, TOUCH=0x01, TEMPERATURE=0x02, REFLECTION=0x03, ANGLE=0x04, LIGHT_ACTIVE=0x05, LIGHT_INACTIVE=0x06, 
      SOUND_DB=0x07, SOUND_DBA=0x08, CUSTOM=0x09, LOWSPEED=0x0A, LOWSPEED_9v=0x0B, NO_OF_SENSOR_TYPES=0x0C};

//sensor moedes
enum {RAW_MODE=0x00, BOOL_MODE=0x20, TRANSITION_MODE=0x40, PERIOD_MODE=0x60, PERCENT_MODE=0x80, CELSIUS_MODE=0xA0, 
      FAHRENHEIT_MODE=0xC0, ANGLE_MODE=0xE0, SLOPE=0x1F, MODEMASK=0xE0}; 



class Sensor{
private:
    int port;
    Serial *comport;
    int get_sensor_value();
    
    int raw;
    int adc;
    int mode;
    int calcu;
          
public:
    Sensor();
    Sensor(int input_port, Serial *cp);
    int type_and_mode(int type, int mode);
    int read();
    int read_raw();
    int read_adc();
    int reset();
};
#endif
