//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "mainform.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
#include <math>
#include <fstream>
#include "serial.hpp"
#include "motor.hpp"
#include "sonar.hpp"
#include "sound.hpp"
#include "brick.hpp"
#include "brick.hpp"
TForm1 *Form1;
double length;
float distance_sonar;
float tyre_radius=0.025;//0.0268 not working
float inch=1;
int limit=0;
int limit_cm;
int limit_inch;
int dir=1;
AnsiString decimal_point="%.0f";
Serial bluetooth;
Sound speaker = Sound(&bluetooth);
Motor wheel = Motor (0, &bluetooth);
Sonar sonar_front;
Sonar sonar_back;
Brick nxt = Brick(&bluetooth);
Sonar *sonar_to_update;
TMemo *distance_to_update;


//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
    sonar_limit->Text=0;
    hide_remote(true);
}
//---------------------------------------------------------------------------
__fastcall sonar_thread::sonar_thread() : TThread(TRUE){
    FreeOnTerminate = TRUE;
    Resume();
}

void __fastcall sonar_thread::Execute(){

   distance_sonar=sonar_to_update->distance()* inch;
   if(Form1->update_sonar->Checked){
       distance_to_update->Text = distance_sonar;
   }
   if(distance_sonar > limit){//To prevent robot from moving
       wheel.on(Form1->speed->Position * 10 * dir);
       do{
           distance_sonar=sonar_to_update->distance()* inch;
           if(Form1->update_sonar->Checked){
               distance_to_update->Text = distance_to_update->Text.sprintf(decimal_point.c_str(),distance_sonar);
           }
           if(Form1->update_length->Checked){
                   length = tyre_radius * wheel.get_rotation() * inch;
                   Form1->show_length->Text= Form1->show_length->Text.sprintf(decimal_point.c_str(), length);
           }
        }while(!Terminated && distance_sonar > limit);
        wheel.stop();

   }
   Form1->hide_button_limit(false);

}

//---------------------------------------------------------------------------
__fastcall free_run_thread::free_run_thread() : TThread(TRUE){
    FreeOnTerminate = TRUE;
    Resume();
}


void __fastcall free_run_thread::Execute(){
   wheel.on(Form1->speed->Position * 10 * dir);
   do{
        if(Form1->update_sonar->Checked){
            distance_sonar=sonar_to_update->distance()*inch;
            distance_to_update->Text = distance_to_update->Text.sprintf(decimal_point.c_str(),distance_sonar);
        }
        if(Form1->update_length->Checked){
            length = tyre_radius * wheel.get_rotation() * inch;
            Form1->show_length->Text= Form1->show_length->Text.sprintf(decimal_point.c_str(), length);

        }
    }while(!Terminated);
    wheel.stop();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::button_conClick(TObject *Sender)
{
    char str_port[15] = "\\\\.\\";
    if(button_con->Caption.operator ==("Disconnect")){
        bluetooth.disconnect();
        output->Clear();
        output->Lines->Add("Disconnecting...");
        button_con->Caption="Connect";
        bt_port->Enabled=true;
        hide_remote(true);
        battery_level->Position=0;
    }
    else{
        strcat(str_port, bt_port->Text.c_str());
        if (bluetooth.connect(str_port)){
           battery_level->Position = nxt.battery_level();
           if(battery_level->Position){
               button_con->Enabled=false;
               button_con->Caption="Disconnect";
               sonar_front = Sonar(front_port->ItemIndex, &bluetooth);
               sonar_back = Sonar(back_port->ItemIndex, &bluetooth);
               wheel.change_port(motor_port->ItemIndex);
               sonar_back.setup();
               sonar_front.setup();
               speaker.beep(300);
               output->Clear();
               output->Lines->Add("Connection OK!");
               hide_remote(false);
               button_con->Enabled=true;
               bt_port->Enabled=false;


           }
           else{
               bluetooth.disconnect();
               output->Clear();
               output->Lines->Add("No NXT!");
               MessageBeep(0xffffffff);
               Sleep(100);
               MessageBeep(0xffffffff);
           }
        }
        else{
           output->Clear();
           output->Lines->Add("COM-PORT NOT OK");
        }
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::motor_portChange(TObject *Sender)
{
    wheel.change_port(motor_port->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::front_portChange(TObject *Sender)
{
    sonar_front = Sonar(front_port->ItemIndex, &bluetooth);
    sonar_front.setup();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::back_portChange(TObject *Sender)
{
    sonar_back = Sonar(back_port->ItemIndex, &bluetooth);
    sonar_back.setup();        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::reset_distanceClick(TObject *Sender)
{
    wheel.reset_rotation();
    show_length->Text=0;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
    if(move_sonar_limit){
        move_sonar_limit->Terminate();
    }
    
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button1Click(TObject *Sender)
{
   Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::stopClick(TObject *Sender)
{
    if(move_sonar_limit){
        move_sonar_limit->Terminate();
    }
    else{
        wheel.stop();
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::fwdMouseDown(TObject *Sender, TMouseButton Button,
      TShiftState Shift, int X, int Y)
{
     if(update_limit()){
         dir=1;
         distance_back->Text="-";
         sonar_to_update = &sonar_front;
         distance_to_update = distance_front;
         if(limit!=0){
              move_sonar_limit = new sonar_thread();
              hide_button_limit(true);

         }
         else{
              move_no_limit = new free_run_thread();
         }
     }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::fwdMouseUp(TObject *Sender, TMouseButton Button,
      TShiftState Shift, int X, int Y)
{
    if(limit==0){
        move_no_limit->Terminate();
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::revMouseDown(TObject *Sender, TMouseButton Button,
      TShiftState Shift, int X, int Y)
{
     if(update_limit()){
         dir=-1;
         distance_front->Text="-";
         sonar_to_update = &sonar_back;
         distance_to_update = distance_back;
         if(limit!=0){
              move_sonar_limit = new sonar_thread();
              hide_button_limit(true);
         }
         else{
              move_no_limit = new free_run_thread();
         }
     }
}
//---------------------------------------------------------------------------

int TForm1::update_limit(){
     int i;
     int limit_high;
     int limit_low;
     AnsiString answer;
     try{
         i=sonar_limit->Text.ToInt();
     }
     catch (EConvertError& e){
        Application->MessageBox("Limit must be valid inteteger",
        "Error - Limit", MB_OK | MB_ICONWARNING);
        return 0;

     }
     if(inch==1){
         limit_low=10;
         limit_high=200;
     }
     else{
          limit_low=4;
          limit_high=80;
     }
     answer="Limit must be 0 or between " + AnsiString(limit_low) + " and " + AnsiString(limit_high);
     answer=answer.c_str();
     if( (i<limit_low || i>limit_high) && i!=0){
            Application->MessageBox(answer.c_str(),"Error - Limit", MB_OK | MB_ICONWARNING);
       return 0;
     }
     limit=i;
     return 1;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::revMouseUp(TObject *Sender, TMouseButton Button,
      TShiftState Shift, int X, int Y)
{
    if(limit==0){
        move_no_limit->Terminate();
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::get_distance_frontClick(TObject *Sender)
{
     distance_front->Text = distance_front->Text.sprintf(decimal_point.c_str(),sonar_front.distance()*inch);

}
//---------------------------------------------------------------------------

void __fastcall TForm1::get_distance_backClick(TObject *Sender)
{
     distance_back->Text = distance_back->Text.sprintf(decimal_point.c_str(),sonar_back.distance()*inch);
}
//---------------------------------------------------------------------------

void TForm1::hide_remote(bool set){
   set=!set;
   speed->Enabled=set;
   sonar_front_box->Enabled=set;
   sonar_back_box->Enabled=set;
   fwd->Enabled=set;
   rev->Enabled=set;
   stop->Enabled=set;
   sonar_limit->Enabled=set;
   update_length->Enabled=set;
   update_sonar->Enabled=set;
   reset_distance->Enabled=set;
   get_length->Enabled=set;
   get_distance_back->Enabled=set;
   get_distance_front->Enabled=set;
   distance_front->Enabled=set;
   distance_back->Enabled=set;
   show_length->Enabled=set;
   set_inch->Enabled=set;

}
void TForm1::hide_button_limit(bool set){
   set=!set;
   get_distance_front->Enabled=set;
   get_distance_back->Enabled=set;
   get_length->Enabled=set;
   speed->Enabled=set;
   sonar_limit->Enabled=set;
   reset_distance->Enabled=set;
   fwd->Enabled=set;
   rev->Enabled=set;
   back_port->Enabled=set;
   front_port->Enabled=set;
   motor_port->Enabled=set;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::get_lengthClick(TObject *Sender)
{
     length=tyre_radius*wheel.get_rotation();
     show_length->Text= show_length->Text.sprintf(decimal_point.c_str(), length);

}
//---------------------------------------------------------------------------


void __fastcall TForm1::set_inchClick(TObject *Sender)
{
     if(set_inch->Checked){
          inch=0.3937;
          decimal_point="%.2f";
          Label2->Caption="inch";
          Label10->Caption="inch";
          unit->Caption="inch";
          Label8->Caption="inch";

          sonar_limit->Text= ceil(sonar_limit->Text.ToInt()*inch);
          update_limit();

     }
     else{
          inch=1;
          decimal_point="%.0f";
          Label2->Caption="cm";
          Label10->Caption="cm";
          unit->Caption="cm";
          Label8->Caption="cm";
          sonar_limit->Text= floor(sonar_limit->Text.ToInt()*2.54);
          update_limit();
     }
}
//---------------------------------------------------------------------------


