#include <iostream>
#include "mailbox.hpp"
#include <stdio.h>
#include <time.h>
#include <string>
#include <stdlib.h>

using namespace std;

    Mailbox::Mailbox(){
                       
    }
    Mailbox::Mailbox(Serial *cp){
        comport=cp;               
    }
    
    int Mailbox::write(string message, int inbox){
         int i=0;
         char command[MAX_NR_BYTES];
         int length=message.length();
         command[0]=length+5;  //command length
         command[1]=0x00;
         
         command[2]=0x80;
         command[3]=0x09;
         command[4]=inbox;
         command[5]=length+1;
         
         while(i<length && i<MAX_NR_BYTES-6){
             command[i+6]=message[i];
             i++;               
         }
         command[i+6]='\0';
         return comport->send(&command[0],length+7);
    }
    
    string Mailbox::read(int inbox, bool remove){
         int i;
         char *answer;
         char command[7];
         command[0]=0x05;  //command length
         command[1]=0x00;
         
         command[2]=0x00;
         command[3]=0x13;
         command[4]=10+inbox;
         command[5]=0x00;
         command[6]=1;
         comport->send(&command[0],7);
         answer = comport->receive(MAX_NR_BYTES);
         i=7;
         while((answer[i]!='\0')){
             answer[i-7]=answer[i];
             i++;                   
         }
         answer[i-7]='\0';
         return answer;              
    }  
    
       
