#ifndef I2C_SENSOR
#define I2C_SENSOR
#include <iostream>
#include <string>
#include "serial.hpp"
#include "sensor.hpp"


using namespace std;


class I2C{
private:
    int port;
    Serial *comport;
    int sensor_status;
    int nr_bytes;
    int  status();
    enum {COM_PENDING=0x20, CHANNEL_BUSY=0xE0};
    
public:
    I2C();
    I2C(int input_port, Serial *cp);
    int sensor_type(int type);
    int  write(char *tx, int tx_length, int rx_length);
    char *read();
    int busy();
};
#endif
