#include <iostream>
#include "i2c.hpp"
#include <stdio.h>
#include <time.h>
#include <string>
#include <stdlib.h>
using namespace std;

    
    I2C::I2C(){
    }
    I2C::I2C(int input_port, Serial *cp){
        port=input_port;
        comport=cp;
        sensor_status=1;
        nr_bytes=0;     
    }
    
    int I2C::sensor_type(int type){
         char command[7];
         command[0]=0x05;  //command length
         command[1]=0x00;

         //start of message
         command[2]=0x80;
         command[3]=0x05;

         command[4]=port;
         command[5]=type;
         command[6]=RAW_MODE;//set mode
         return comport->send(&command[0],7);    
    }
    
    
    int I2C::status(){
        char command[5];
        char *answer;
        command[0]=0x03;
        command[1]=0x00;
        
        command[2]=0x00;
        command[3]=0x0E;
        command[4]=port;
        comport->send(&command[0],5);    
        answer=comport->receive(6);
        sensor_status=answer[4];
        nr_bytes=answer[5];
        return 1;     
    }
    
    
    int I2C::write(char *tx, int tx_length, int rx_length){
        int i=0;
        char command[24];
        
        while(i < tx_length){
            command[i+7]=tx[i];
            i++;
            //printf("i=%d\n",i);          
        }
        command[0]=i+5;
        command[1]=0x00;
        
        command[2]=0x80;
        command[3]=0x0F;
        command[4]=port;
        command[5]=i;
        command[6]=rx_length;
        return comport->send(&command[0],i+7);
    }
    
    int I2C::busy(){
        status();
        if(sensor_status == COM_PENDING || sensor_status == CHANNEL_BUSY){
            return 1;               
        }
        return 0;
    }
    
    
    char * I2C::read(){
        char command[5];
        char *answer;
        
        command[0]=0x03;
        command[1]=0x00;
        
        command[2]=0x00;
        command[3]=0x10;
        command[4]=port;
        comport->send(&command[0],5);    
        answer=comport->receive(24);
        return &answer[5];//first 5 bytes discarded   
    }
