#include <iostream>
#include "sonar.hpp"
#include <stdio.h>
#include <time.h>
#include <string>
#include <stdlib.h>
using namespace std;

    
    Sonar::Sonar(){
    }
    Sonar::Sonar(int input_port, Serial *cp){
        sensor = I2C(input_port,cp);
        cm=1;  
        inch=0.3937; 
        mode=cm;
        scale_factor=0;
    }
    
   int Sonar::write_register(int reg_adr, int value){
        char command[3];
        command[0]=SONAR_ADDRESS;
        command[1]=reg_adr;
        command[2]=value;
        return sensor.write(&command[0],3,0x00);
   }
    
    
    int Sonar::read_register(int reg_adr){
        char *answer;
        static char command[2];
        command[0]=SONAR_ADDRESS;    
        command[1]=reg_adr;    
        sensor.write(&command[0], 2, 1);
        while(sensor.busy()){}
        answer=sensor.read();
        return 0xff & answer[1]; //returns unsigned value         
    }
    
    int Sonar::sensor_mode(int mode){
        return write_register(COMMAND,mode);
    }

    int Sonar::off(){
        return sensor_mode(OFF);    
    }
    
    int Sonar::setup(){
        sensor.sensor_type(LOWSPEED_9v);
        distance();
        distance();
        distance();//Otherwise the first measurement fails
        off();
        return 1;    
    }
    
    int Sonar::distance(){
         sensor_mode(SINGLE_SHOT);
         while(sensor.busy()){}
         return mode * (float) (read_register(RESULT_1)+ scale_factor); 
    }
    int Sonar::inch_mode(){
        mode=inch;  //hack see bottom of file  
        return 1; 
    }

    int Sonar::cm_mode(){
        mode=cm;   //hack see bottom of file 
        return 1;
    }
    
    int Sonar::set_scale(int factor){
        scale_factor=factor;          //hack see bottom of file 
        return 1;
    }
    
    int Sonar::reset(){
        return sensor_mode(REQUEST_WARM_RESET);    
    }

    
    int Sonar::get_command_state(){
        return  read_register(COMMAND);     
    }
    
    int Sonar::get_zero_value(){
         return  read_register(ZERO_VALUE);        
    }
    
    int Sonar::get_scale_factor(){
         return  read_register(SCALE_FACTOR);       
    }
    
    int Sonar::get_scale_divisor(){
         return  read_register(SCALE_DIVISOR);       
    }

    int Sonar::get_factory_zero_value(){
         return  read_register(FACTORY_ZERO_VALUE);        
    }
    
    
    int Sonar::get_factory_scale_factor(){
         return  read_register(FACTORY_SCALE_FACTOR);        
    }
    
    int Sonar::get_factory_scale_divisor(){
         return  read_register(FACTORY_SCALE_DIVISOR);        
    }
    
    int Sonar::set_measurement_interval(int interval){
        return write_register(INTERVAL, interval);
    }
    
    /*For some reason I am not able to change the scale, divisor and zero factor with these funcktions */
    
    int Sonar::set_zero_value(int value){
        return write_register(ZERO_VALUE, value);
    }
    
    int Sonar::set_scale_factor(int factor){
        return write_register(SCALE_FACTOR, factor);
    }
    
    
    int Sonar::set_scale_divisor(int divisor){
        return write_register(SCALE_DIVISOR, divisor);
    }
    
    
    
    
    /*End of not working */
    
    
/********* Work in progress******/    
    /*int Sonar::record(){
        char *answer;
        static char command[2];
        //mode(CONTINUOUS_MEASUREMENT);
        //while(sensor.busy()){}
        command[0]=0x02;    
        command[1]=0x42;    
        sensor.write(&command[0], 2, 8);
        while(sensor.busy()){}
        answer=sensor.read();
        return answer[1];         
    }*/
    
    

