#ifndef MOTOR
#define MOTOR
#include <iostream>
#include <string>
#include "serial.hpp"

using namespace std;

class Motor{
private:
    int port;
    Serial *comport;
    int mode;
    int reg_mode;
    int run_state;
    int turnratio;
    
    long unsigned int tacho_limit; 
    long int tacho_count;
    long int block_count;
    long int rotation_count;
    
    //mode
    enum {MOTOR_ON=0x01,BREAK=0x02,REGULATED=0x04};
    //regulation 
    enum {REG_IDLE=0x00,MOTOR_SPEED=0x01, MOTOR_SYNC=0x02};
    //run state 
    enum {RUN_IDLE=0x00,RAMP_UP=0x10, RUNNING=0x20,RAMP_DOWN=0x40};
    
    int reset(bool relative); 
    int get_output_state(); 
    int set_output_state(int set_speed, int set_mode,int set_regulation, int set_turn_ratio,int set_run_state, long unsigned int set_tacho_limit); 
    int move_to(int speed, long int target, int tol);
    /*Test function*/
    //int Motor::slow_down();
    
public:
    Motor();
    Motor(int output_port, Serial *cp);
    int on(int speed);
    int on(int speed, long unsigned int degrees);
    int move_to(int speed, long int target);
    int change_port(int new_port);
    //Needs some work
    
    bool is_running();
    int stop();
    int off();
    int reset_rotation();
    long int get_rotation();    
};
#endif
